/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Scheduler.h
\brief      Multi-Thread Scheduler definitions
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/20/2008
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#ifndef __SCHEDULER_H__
  #define __SCHEDULER_H__
  /*--------------------------Includes -------------------------------------------------------------*/
  #include "Derivative.h"
  #include "Mcu.h"
  #include "Emios.h"
    	
	/** Timing constants                           */
    #define   LOOP_TIME_100ms    (((float32_t)SYS_FREQ *  (float32_t)0.100) / ((float32_t)eMIOS_GLOBAL_PRESCALER * (float32_t)eMIOS_TM_LOCAL_PRESCALER))
    #define   LOOP_TIME_50ms     (((float32_t)SYS_FREQ *  (float32_t)0.05)  / ((float32_t)eMIOS_GLOBAL_PRESCALER * (float32_t)eMIOS_TM_LOCAL_PRESCALER))
	
	/* -- External Global Variables ---------------------------------------------*/
	extern uint8_t gu8Scheduler_Ctrl;
	extern uint8_t gu8Scheduler_Flag;
	extern uint8_t gu8SleepModeEnabled;
	/*---------------------------- Functions ------------------------------------*/
	void vfnScheduler_Init(void);
	void vfnStart_Scheduler(void);
	void Scheduler_Fnc_Handler(void);
#endif  